<?php
require_once("../layouts/members/head.php");
if ($user_data['dl_pdf_service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
             <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()" > <i class="fas fa-arrow-left"></i> Back</button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          $response = []; // Initialize response array

          if (isset($_POST['submit'])) {
              $dlNumber = strtoupper($_POST['dlNumber']);
              $dob = $_POST['dobenter'];
               
              if (!empty($dlNumber) && !empty($dob)) {
                  $amount = $user_data['dl_pdf_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($user_data['balance'] >= $amount) {
                      $order_id = order_txn_id();
                      
                      // --- NEW API IMPLEMENTATION START ---
                      $apiKey = "APIKEYPASTEE"; // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )
                      $apiUrl = "https://kycapizone.in/api/v2/dl/dl_verify.php?api_key=" . $apiKey . "&dl_number=" . $dlNumber . "&dob=" . $dob;

                      $curl = curl_init();
                      curl_setopt_array($curl, array(
                         CURLOPT_URL => $apiUrl,
                         CURLOPT_RETURNTRANSFER => true,
                         CURLOPT_ENCODING => '',
                         CURLOPT_MAXREDIRS => 10,
                         CURLOPT_TIMEOUT => 30,
                         CURLOPT_FOLLOWLOCATION => true,
                         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                         CURLOPT_CUSTOMREQUEST => 'GET',
                         CURLOPT_SSL_VERIFYPEER => false,
                      ));

                      $responseApi = curl_exec($curl);
                      curl_close($curl);
                      
                      $json_data = json_decode($responseApi, true) ?? [];

                      if (isset($json_data['status']) && $json_data['status'] == '100') {
                          
                          $apiResult = $json_data['result'] ?? [];
                          
                          $response['status'] = '100';
                          $response['dlno'] = $apiResult['dl_number'] ?? $dlNumber;
                          $response['dob'] = $apiResult['dob'] ?? $dob;
                          $response['name'] = 'NA'; // Name not provided in this API response
                          
                          // API returns Base64 Data URIs directly
                          $response['front'] = $apiResult['front'] ?? ''; 
                          $response['back'] = $apiResult['back'] ?? '';
                          $response['pdf'] = $apiResult['a4'] ?? '';

                          $updateSuccess = db_update("members", ["balance" => $new_balance], " user_id='" . $user_data['user_id'] . "' ");

                          if ($updateSuccess) {
                              $printData = array(
                                  'dlno' => $response['dlno'],
                                  'dob' => $response['dob'],
                                  'front' => $response['front'], // Saving base64 to printData
                                  'back' => $response['back'],
                                  'pdf' => $response['pdf'],
                                  'username' => $user_data['username']
                              );
                              
                              $Mremark = 'DL Number: ' . $dlNumber;
                              $insData = [
                                  'order_id'       => $order_id,
                                  'username'       => $user_data['username'],
                                  'name'           => $response['name'],
                                  'idNumber'       => $dlNumber,
                                  'service'        => "DL PDF",
                                  'date_time'      => current_timestamp(),
                                  'printData'      => base64_encode(str_replace("\\", "", json_encode($printData, JSON_UNESCAPED_UNICODE))),
                                  'photo'          => "",
                              ];

                              $insertId = db_insert("printRecords", $insData);
                              
                              if ($insertId) {
                                  $insData = [
                                      'site_id'       => $site_data['site_id'],
                                      'user_id'       => $user_data['user_id'],
                                      'username'      => $user_data['username'],
                                      'name'          => $user_data['name'],
                                      'operator'      => $user_data['usertype'],
                                      'parent_id'     => $user_data['parent_id'],
                                      'order_id'      => $order_id,
                                      'service'       => "DL PDF",
                                      'type'          => "Debit",
                                      'account_number'=> $response['dlno'],
                                      'app_type'      => "DL PDF",
                                      'amount'        => $amount,
                                      'main_amount'   => $amount,
                                      'old_balance'   => $old_balance,
                                      'new_balance'   => $new_balance,
                                      'txn_id'        => $order_id,
                                      'ref_id'        => $response['dlno'],
                                      'description'   => "Rs.{$amount} Has Been Debit From Wallet for DL PDF HD By DL Number ",
                                      'date_time'     => current_timestamp(),
                                      'status'        => "Success"
                                  ];

                                  $insertIdReport = db_insert("reports", $insData);
                                  if ($insertIdReport) {
                                      $fields = [
                                          'dlno' => 'DL No',
                                          'dob' => 'DOB',
                                      ];

                                      $whamessage = "Dear {$user_data['name']},\nYour Request for DL Number *{$dlNumber}* PDF has been Complete.\n\n";

                                      foreach ($fields as $key => $label) {
                                          if (!empty($response[$key])) {
                                              $whamessage .= "*$label*: {$response[$key]}\n";
                                          }
                                      }
                                      $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                      send_sms($user_data['mobile'],$whamessage);
                                  } else {
                                      awal_alert_msg("Insert Server Error!", 'error');
                                  }
                              } else {
                                  awal_alert_msg("Saving Print Data Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          $msg = $json_data['message'] ?? 'Server Down or Data Not Found';
                          awal_alert_msg($msg, 'error');
                      }
                      // --- NEW API IMPLEMENTATION END ---
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>DL Number</label>
              <input type="text" name="dlNumber" placeholder="Enter DL Number" maxlength="25" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==25) return false;" required>
            </div>
            <div class="col-md-12 mb-3">
              <label>Date Of Birth</label>
              <input type="text" name="dobenter" id="dob" placeholder="10-05-2000" class="form-control" autocomplete="off" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo $user_data['dl_pdf_fee'];?></button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
              
              <?php if (isset($response['front']) && !empty($response['front'])) { ?>
                  <a href="<?php echo $response['front'];?>" class="btn btn-danger" download="<?php echo $response['dlno']; ?>_front.pdf"><i class="fas fa-download"></i>Front PVC</a>
                  <a href="<?php echo $response['back'];?>" class="btn btn-warning" download="<?php echo $response['dlno']; ?>_back.pdf"><i class="fas fa-download"></i>Back PVC</a>
              <?php } ?>
            </div>
          </form>
        </div>
      </div>
    </div>

<?php if (isset($response['pdf']) && !empty($response['pdf'])) { ?>
  <div class="col-md-8 mb-2">
    <div class="card text-danger">
      <div class="card-header bg-primary text-white py-2">
        <span>your PDF is ready to download...</span>
        <a href="<?php echo $response['pdf']; ?>" download="<?php echo htmlspecialchars($response['dlno']); ?>.pdf" class="btn btn-warning">
          <i class="fas fa-download"></i> Download PDF
        </a>
      </div>
      <iframe src="<?php echo $response['pdf']; ?>" 
              style="width: 100%; height: 600px; border: 1px solid #ccc;" frameborder="0">
      </iframe>
    </div>
  </div>
<?php } ?>
</div>

<script>
  flatpickr("#dob", {
    dateFormat: "d-m-Y", 
    allowInput: true,   
    maxDate: "today",  
    onChange: function(selectedDates, dateStr, instance) {
      console.log("Selected date:", dateStr); 
    }
  });
</script>
<?php
} else {
    require_once("404.php");
}
} else {
    awal_alert_msg('You Do Not Have Any Vehical Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>